const UserProfileModel = require('../models/UserProfileModels');

const GetProfileByID = async (req, res) => {
  const { ProfileID } = req.query; // Use req.query to get the query parameter

  try {
    const profilebyid = await UserProfileModel.getProfilebyID(ProfileID); // Updated function name
    if (!profilebyid) {
      return res.status(404).json({ message: 'User Profile not found' });
    }
    res.json(profilebyid);
  } catch (error) {
    res.status(500).json({ message: error.message });
  }
};

const GetProfile = async (req, res) => {
  try {
    const profileList = await UserProfileModel.GetProfile();
    if (!profileList.length) {
      return res.status(404).json({ message: 'No records found' });
    }
    res.json(profileList);
  } catch (error) {
    res.status(500).json({ message: error.message });
  }
};
const CreateProfile = async (req, res) => {
    const profileData = req.body; // Assuming the request body contains the profile data
  
    try {
      const newProfileID = await UserProfileModel.insertProfile(profileData);
      res.status(201).json({ message: 'Profile created successfully', ProfileID: newProfileID });
    } catch (error) {
      res.status(500).json({ message: error.message });
    }
  };
  
module.exports = { GetProfileByID, GetProfile,CreateProfile  };
