// controllers/form_siswaController.js
const MasterSekolahModels = require('../models/MasterSekolahModels');

const GetSekolahByID = async (req, res) => {
  const { SekolahID } = req.query; // Use req.query to get the query parameter

  try {
    const sekolahbyid = await MasterSekolahModels.getSekolahbyID(SekolahID);
    if (!sekolahbyid) {
      return res.status(404).json({ message: 'Sekolah not found' });
    }
    res.json(sekolahbyid);
  } catch (error) {
    res.status(500).json({ message: error.message });
  }
};
const GetSekolah = async (req, res) => {
    try {
      const sekolahList = await MasterSekolahModels.getSekolah();
      if (!sekolahList.length) {
        return res.status(404).json({ message: 'No records found' });
      }
      res.json(sekolahList);
    } catch (error) {
      res.status(500).json({ message: error.message });
    }
  };
  
module.exports = { GetSekolahByID, GetSekolah };
