const express = require('express');
const cors = require('cors');
const app = express();
const authroutes = require('./routes/authroutes');
const formRoutes = require('./routes/form_siswaroutes');
const GerejaRoutes = require('./routes/GerejaRouters');
const SekolahRoutes = require('./routes/SekolahRoutes');
const KodePosRoutes = require('./routes/KodePosRoutes');
const UserProfile = require('./routes/UserProfile'); // Ensure this path is correct

// Middleware to enable CORS
const corsOptions = {
  origin: '*', // Allows all domains to access your API
  methods: ['GET', 'POST', 'PUT', 'DELETE'],
  allowedHeaders: ['Content-Type', 'Authorization'],
  credentials: true
};

app.use(cors(corsOptions));

app.use(cors(corsOptions));

// Middleware to parse JSON requests
app.use(express.json());

// Use user routes
app.use('/api', authroutes);
app.use('/form', formRoutes);
app.use('/gereja', GerejaRoutes);
app.use('/sekolah', SekolahRoutes);
app.use('/kodepos', KodePosRoutes);
app.use('/userprofile', UserProfile); // Fixed the path here

const PORT = process.env.PORT || 8080;
app.listen(PORT, () => {
  console.log(`Server is running on port ${PORT}`);
});
