// models/userModel.js
const bcrypt = require('bcrypt');
const pool = require('../config/dbConfig'); // Menggunakan pool dari mysql2

const getUserByUsername = async (Email) => {
  try {
    const [rows] = await pool.query('SELECT * FROM users WHERE Email = ?', [Email]);
    return rows[0];
  } catch (error) {
    console.error('Database query error:', error.code, error.sqlMessage); // Log error code and message
    throw new Error('Database query failed');
  }
};

const authenticateUser = async (Email, Password) => {
  try {
    const user = await getUserByUsername(Email);

    if (!user) {
      throw new Error('User not found');
    }

    // Verify the Password
    const isMatch = await bcrypt.compare(Password, user.Password);
    if (!isMatch) {
      throw new Error('Invalid Password');
    }

    return user;
  } catch (error) {
    console.error('Authentication error:', error); // Log the error details
    throw new Error(error.message);
  }
};

const createUser = async (Email, hashedPassword,FullName,SekolahID,UserType) => {
    try {
      await pool.query('INSERT INTO users (Email, Password,FullName,SekolahID,UserType) VALUES (?, ?, ?, ?, ?)', [Email, hashedPassword,FullName,SekolahID,UserType]);
    } catch (error) {
      throw new Error('Database query failed');
    }
  };

module.exports = {
  getUserByUsername,
  authenticateUser,
  createUser
};
