// controllers/form_siswaController.js
const formModel = require('../models/form_siswaModels');

const getFormByNospj = async (req, res) => {
  const { nospj } = req.query; // Use req.query to get the query parameter

  try {
    const form = await formModel.getform(nospj);
    if (!form) {
      return res.status(404).json({ message: 'Form not found' });
    }
    res.json(form);
  } catch (error) {
    res.status(500).json({ message: error.message });
  }
};

module.exports = { getFormByNospj };
