// controllers/form_siswaController.js
const MasterKodePos = require('../models/MasterKodePos');

const GetKodePosByID = async (req, res) => {
  const { id } = req.query; // Use req.query to get the query parameter

  try {
    const Id = await MasterKodePos.getKodePosbyID(id);
    if (!Id) {
      return res.status(404).json({ message: 'Kode Pos not found' });
    }
    res.json(Id);
  } catch (error) {
    res.status(500).json({ message: error.message });
  }
};
const GetKodePos = async (req, res) => {
    try {
      const KodePosList = await MasterKodePos.getKodePos();
      if (!KodePosList.length) {
        return res.status(404).json({ message: 'No records found' });
      }
      res.json(KodePosList);
    } catch (error) {
      res.status(500).json({ message: error.message });
    }
  };
  
module.exports = { GetKodePosByID, GetKodePos };
